/*
 * Created on Oct 8, 2005
 */
package org.me.plugin.sample4.dialogs;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.me.plugin.sample4.Activator;
import org.me.plugin.sample4.views.SampleView;

public class EditDialog extends Dialog
{

	private SampleView	view;

	public EditDialog( Shell parent )
	{
		super( parent );
	}

	public Object open( SampleView view )
	{
		this.view = view;
		ISelection selection = view.getTableViewer( ).getSelection( );
		String key = ( String ) ( ( IStructuredSelection ) selection ).getFirstElement( );
		Shell parent = getParent( );
		final Shell shell = new Shell( parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL | SWT.RESIZE );
		shell.setImage( Activator.getImageDescriptor( "icons/edit.gif" ).createImage( ) );
		Display display = parent.getDisplay( );
		shell.setText( "Edit" );
		shell.setSize( 300, 140 );
		shell.setLocation( ( display.getPrimaryMonitor( ).getClientArea( ).width - shell.getSize( ).x ) / 2, ( display.getPrimaryMonitor( ).getClientArea( ).height - shell.getSize( ).y ) / 2 );
		createContents( shell, key );
		shell.open( );
		while ( ! shell.isDisposed( ) )
		{
			if ( ! display.readAndDispatch( ) )
				display.sleep( );
		}
		return null;
	}

	private void createContents( final Shell shell, final String key )
	{
		shell.setLayout( new GridLayout( 2, false ) );
		// Container
		Composite composite = new Composite( shell, SWT.NONE );
		composite.setLayout( new GridLayout( 2, false ) );
		GridData gridData = new GridData( GridData.FILL_BOTH | GridData.GRAB_HORIZONTAL | GridData.GRAB_VERTICAL );
		gridData.horizontalSpan = 2;
		composite.setLayoutData( gridData );
		//
		Label label = new Label( composite, SWT.NONE );
		label.setText( "Key" );
		label.setLayoutData( new GridData( ) );
		final Text keyText = new Text( composite, SWT.BORDER );
		keyText.setText( key );
		keyText.setLayoutData( new GridData( GridData.FILL_HORIZONTAL | GridData.GRAB_HORIZONTAL ) );
		label = new Label( composite, SWT.NONE );
		label.setText( "Value" );
		label.setLayoutData( new GridData( ) );
		final Text valueText = new Text( composite, SWT.BORDER );
		valueText.setText( view.getProperties( ).getProperty( key ) );
		valueText.setLayoutData( new GridData( GridData.FILL_HORIZONTAL | GridData.GRAB_HORIZONTAL ) );
		//
		Button ok = new Button( shell, SWT.PUSH );
		ok.setText( "OK" );
		ok.addSelectionListener( new SelectionAdapter( )
		{

			public void widgetSelected( SelectionEvent event )
			{
				view.getProperties( ).setProperty( keyText.getText( ), valueText.getText( ) );
				view.getTableViewer( ).refresh( );
				shell.close( );
			}
		} );
		gridData = new GridData( GridData.HORIZONTAL_ALIGN_END | GridData.GRAB_HORIZONTAL );
		gridData.widthHint = 75;
		ok.setLayoutData( gridData );
		Button cancel = new Button( shell, SWT.PUSH );
		cancel.setText( "Cancel" );
		cancel.addSelectionListener( new SelectionAdapter( )
		{

			public void widgetSelected( SelectionEvent event )
			{
				shell.close( );
			}
		} );
		gridData = new GridData( GridData.HORIZONTAL_ALIGN_BEGINNING );
		gridData.widthHint = 75;
		cancel.setLayoutData( gridData );
		shell.setDefaultButton( ok );
	}
}
