package org.ait.aspects.listeners;

import java.util.Vector;

public class Counter extends Thread {
	private Vector listeners = new Vector();
	private int count = 0;
		
	public void run() {
		while(true) {
			try {
				sleep(1000);
			}
			catch(InterruptedException e) {
				e.printStackTrace();
			}
			count++;
			notifyCounterChange(count);
		}
	}
	
	public void startCounting() {
		this.start();
	}
	
	protected void notifyCounterChange(int count){
		Vector tmpList;
		CounterEvent ce = new CounterEvent(this, count);
		synchronized (this) {
			tmpList = (Vector) listeners.clone();
		}
		for(int i=0; i<tmpList.size();i++){
			((CounterChangeListener)tmpList.elementAt(i)).counterChange(ce);
		}
	}
	
	public synchronized void addCounterChangeListener(CounterChangeListener cc1) {
		listeners.addElement(cc1);
	}

	public synchronized void removeCounterChangeListener(CounterChangeListener cc1) {
		listeners.removeElement(cc1);
	}
}
