package org.ait.reflection;

import java.awt.Rectangle;
import java.lang.reflect.Constructor;

class ArgsCreate {

	public static void main(String[] args) {
		Class rectangleDefinition;
		Class[] intArgsClass = new Class[] { int.class, int.class };
		Integer height = new Integer(12);
		Integer width = new Integer(34);
		Object[] intArgs = new Object[] { height, width };
		Constructor intArgsConstructor;

		try {
			rectangleDefinition = Class.forName("java.awt.Rectangle");
			intArgsConstructor = rectangleDefinition
					.getConstructor(intArgsClass);
			Rectangle rectangle = (Rectangle) createObject(intArgsConstructor,
					intArgs);
		} catch (Exception e) {
			System.out.println(e);
		} 
	}

	public static Object createObject(Constructor constructor,
			Object[] arguments) {
		System.out.println("Constructor: " + constructor.toString());
		Object object = null;

		try {
			object = constructor.newInstance(arguments);
			System.out.println("Object: " + object.toString());
			return object;
		} catch (Exception e) {
			System.out.println(e);
		}
		return object;
	}
}
