package org.ait.smartproxy.example1;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;

public class DoorServerImpl extends UnicastRemoteObject implements DoorServer {
	private Hashtable hashtable = new Hashtable();

	public DoorServerImpl() throws RemoteException {
		DoorImpl impl = new DoorImpl("location1");
		hashtable.put(impl.getLocation(), impl);
	}

	public Door getDoor(String location) throws RemoteException {
		return (Door) hashtable.get(location);
	}

	public static void main(String args[]) {
		try {
			DoorServerImpl server = new DoorServerImpl();
			Naming.bind("rmi://localhost/DoorServer", server);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
