package org.ait.smartproxy.example2;

import java.io.Serializable;
import java.rmi.RemoteException;

public class DoorProxy implements Serializable, Door {
	private DoorRemote impl = null;
	private String cachedName = null;
	
	DoorProxy(DoorRemote impl) throws RemoteException {
		this.impl = impl;
		// read the value once
		cachedName = impl.getLocation();
	}
	
	public String getLocation() throws RemoteException {
		return cachedName;
	}
	
	public boolean isOpen() throws RemoteException {
		return impl.isOpen();
	}
}
