package rsa;
/*   
 *   Keys osztly az RSA kulcsainak generlst s trolsa vgzi. 
 */

import java.math.*;
import java.util.*;

public class Keys {


	// Az egyet BigIntegerknt brzoljuk
	private final BigInteger ONE = new BigInteger("1");

	// A nyilvnos kulcs 
	private BigInteger p;

	// A titkos kulcs
	private BigInteger s;

	// A modul rtke
	private BigInteger N;

	// Vletlen szmknt genert prm
	private BigInteger x;

	// Vletlen szmknt generlt prm
	private BigInteger y;

	
	public Keys() {
		x = new BigInteger(64, 99, new Random());
		y = new BigInteger(64, 99, new Random());
		s = new BigInteger(64, 99, new Random());

		// Modul kiszmtshoz egy 1-0,5^100 valsznsggel prmet lltunk el
		while(!x.isProbablePrime(100)) {
			x = new BigInteger(64, 99, new Random());
		}
		
		// Modul kiszmtshoz egy 1-0,5^100 valsznsggel prmet lltunk el
		while(!y.isProbablePrime(100)) {
			y = new BigInteger(64, 99, new Random());
		}

		// A titkos kulcs ellltsa, ami 1-0,5^100 valsznsggel prm
		while(!s.isProbablePrime(100)) {
			s = new BigInteger(64, 99, new Random());
		}
		
		// A nyilvnos kulcs ellltsa 
		p = s.modInverse(x.subtract(ONE).multiply(y.subtract(ONE)));
		// A modul ellltsa
		N = x.multiply(y);
	}


	// Visszaadja a nyilvnos kulcs rtkt
	public BigInteger getPublicKey() {
		return p;
	}

	// Visszaadja a modul rtkt 
	public BigInteger getModulo() {
		return N;
	}

	// Visszadaja a titkos kulcs rtkt
	public BigInteger getPrivateKey() {
		return s;
	}

	// A  nyilvnos kulcsot, mint egy karakterlncot ad vissza rtkl
	public String getPublicKeyString() {
		return p.toString();
	}

	// A titkos kulcsot, mint egy karakterlncot adja vissza rtkl
	public String getPrivateKeyString() {
		return s.toString();
	}

	// A modult, mint karakterlncot adja vissza rtkl
	public String getModuloString() {
		return N.toString();
	}

	// Nyilvnos kulcsot beolvas metdus
	public boolean setPublicKey(String value) {
		try {
			p = new BigInteger(value);
		}
		catch(NumberFormatException e) {
			return false;
		}
		return true;
	}

	// Titkos kulcsot beolvas metdus
	public boolean setPrivateKey(String value) {
		try {
			s = new BigInteger(value);
		}
		catch(NumberFormatException e) {
			return false;
		}
		return true;
	}

	// Modult beolvas metdus
	public boolean setModulo(String value) {
		try {
			N = new BigInteger(value);
		}
		catch(NumberFormatException e) {
			return false;
		}
		return true;
	}

} // Keys osztly vge
