package rsa;
/*   
 *     RSA osztly a szvegek kdolst s dekodolst vgzi.
 */

import java.math.*;

public class RSA {

	// Szveget kdol metdus
	public static BigInteger[] encrypt(String message, BigInteger publickey, BigInteger modulo) {
		byte[] temp;
		byte[] digits = message.getBytes();

		BigInteger[] bigdigits = new BigInteger[digits.length];

		for (int i = 0; i < bigdigits.length; i++) {
			temp = new byte[1];
			temp[0] = digits[i];
			bigdigits[i] = new BigInteger(temp);
		}

		BigInteger[] encrypted = new BigInteger[bigdigits.length];

		try {
			for(int j = 0; j < bigdigits.length; j++)
				encrypted[j] = bigdigits[j].modPow(publickey, modulo);
		}
		catch(Exception e) {
			return null;
		}

		return encrypted;
	}

	// Kdolt szveg visszafejtst vgz metdus
	public static String decrypt(BigInteger[] encrypted, BigInteger privatekey, BigInteger modulo) {
		BigInteger[] decrypted = new BigInteger[encrypted.length];

		try {
			for(int i = 0; i < decrypted.length; i++)
				decrypted[i] = new BigInteger(encrypted[i].toString()).modPow(privatekey, modulo);
		}
		catch(Exception e) {
			return null;
		}

		char[] array = new char[decrypted.length];

		for(int j = 0; j < array.length; j++)
			array[j] = (char)(decrypted[j].intValue());

		return new String(array);
	}

} // RSA osztly vge
