package rsa;
/*	   RSA algoritmus segtsgvel kdol demo-applet, 1999. 

		Egyszer applet, ami a RSA algoritmus segtsgvel zeneteket
		kpes kdolni s visszakdolni. A titkos s a nyilvnos kulcsokat 
		az applet maga is tud generlni, de mr meglv kulcsok beolvassra 
		is lehetsget ad a program.
		Az applet futtatshoz szksges a kt tovbbi fjl Keys, ami a 
		kulcsok generlst trolst s RSA, ami a kdols s dekdolst vgzi. 
*/

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.math.*;
import java.util.*;


public class RSAClient extends Applet implements ActionListener {

//Vltozk definilsa
	// Az adatmez
	private Keys keys;
	private Font f;
	private String message;
	private String decrypted;
	private BigInteger[] encrypted;

	// A grafikus felhasznli fellet elemei
	//Cimkk
	private Label titlelabel = new Label("RSA algoritmussal kdol applet");
	private Label statuslabel =  new Label("llapot: ");
	private Label messagelabel = new Label("zenet:");
	private Label publickeylabel = new Label("Nyilvnos kulcs:");
	private Label privatekeylabel = new Label("Titkos kulcs:");
 	
	//Szvegmezk
	private TextField publickeyfield = new TextField(40);
	private TextField privatekeyfield = new TextField(40);

	private TextArea textarea = new TextArea("", 8, 40, TextArea.SCROLLBARS_VERTICAL_ONLY);

	//Nyomgombok
	private Button encryptbutton = new Button("Kdols");
	private Button decryptbutton = new Button("Dekdols");
	private Button generatebutton = new Button("j kulcsok");
	private Button setpublicbutton = new Button("Nyilvnos kulcs beolvassa");
	private Button setprivatebutton = new Button("Titkos kulcs beolvassa");

//A felhasznli fellethez kapcsolod metdusok
	
	// Applet indtsa
	public void init() {

		// Font bellts
		f = new Font("Serif", Font.PLAIN, 24);
		titlelabel.setFont(f);

		f = new Font("SansSerif", Font.PLAIN, 14);
		statuslabel.setFont(f);

		// Inicializljuk a Layout manager-t
		GridBagLayout gbl = new GridBagLayout();
		GridBagConstraints gbc = new GridBagConstraints();

		setLayout(gbl);

		// A komponenseket feltesszk a felhasznli felletre
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.gridwidth = 3;
		gbc.insets.bottom = 8;
		gbl.setConstraints(titlelabel, gbc);
		add(titlelabel);

		gbc.gridx = 0;
		gbc.gridy = 1;
		gbc.insets.bottom = 0;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.anchor = GridBagConstraints.WEST;
		gbl.setConstraints(messagelabel, gbc);
		add(messagelabel);

		gbc.gridx = 0;
		gbc.gridy = 2;
		gbl.setConstraints(textarea, gbc);
		add(textarea);

		gbc.gridx = 0;
		gbc.gridy = 3;
		gbc.insets.top = 8;
		gbl.setConstraints(publickeylabel, gbc);
		add(publickeylabel);

		gbc.gridx = 0;
		gbc.gridy = 4;
		gbc.gridwidth = 2;
		gbc.insets.top = 0;
		gbc.fill = GridBagConstraints.NONE;
		gbl.setConstraints(publickeyfield, gbc);
		add(publickeyfield);

		gbc.gridx = 2;
		gbc.gridy = 4;
		gbc.gridwidth = 1;
		gbl.setConstraints(setpublicbutton, gbc);
		add(setpublicbutton);

		gbc.gridx = 0;
		gbc.gridy = 5;
		gbc.gridwidth = 3;
		gbc.insets.top = 8;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbl.setConstraints(privatekeylabel, gbc);
		add(privatekeylabel);

		gbc.gridx = 0;
		gbc.gridy = 6;
		gbc.gridwidth = 2;
		gbc.insets.top = 0;
		gbc.fill = GridBagConstraints.NONE;
		gbl.setConstraints(privatekeyfield, gbc);
		add(privatekeyfield);

		gbc.gridx = 2;
		gbc.gridy = 6;
		gbc.gridwidth = 1;
		gbl.setConstraints(setprivatebutton, gbc);
		add(setprivatebutton);

		Panel p = new Panel();
		p.add(encryptbutton);
		p.add(decryptbutton);
		p.add(generatebutton);

		gbc.gridx = 0;
		gbc.gridy = 7;
		gbc.gridwidth = 3;
		gbc.insets.top = 0;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbl.setConstraints(p, gbc);
		add(p);

		encryptbutton.addActionListener(this);
		decryptbutton.addActionListener(this);
		generatebutton.addActionListener(this);
		setpublicbutton.addActionListener(this);
		setprivatebutton.addActionListener(this);

		gbc.gridx = 0;
		gbc.gridy = 8;
		gbc.insets.top = 8;
		gbc.anchor = GridBagConstraints.WEST;
		gbl.setConstraints(statuslabel, gbc);
		add(statuslabel);
	}
	// j nyilvnos kulcspr generl metdus
	public void getKeys() {
	
		statuslabel.setText("llapot: j kulcsok ksztse");

		keys = new Keys();

		publickeyfield.setText(keys.getPublicKeyString());
		privatekeyfield.setText(keys.getPrivateKeyString());

		statuslabel.setText("llapot:a kulcsok kszen vannak");
	}


	// Az zenetet beolvassa a kpernyrl s kdolshoz elkszti
	public BigInteger[] getEncryptedText() {

		BigInteger[] temp;
		StringTokenizer tok;
		Vector v = new Vector();
		String s = new String();

		// Az zenet beolvassa a szveg mezbl
		String messagetext = new String(textarea.getText());

		// A felesleges whitespace-tl megszabadulunk
		tok = new StringTokenizer(messagetext);
		while(tok.hasMoreTokens()) {
			s = s.concat(tok.nextToken());
		}

		// A beolvasott szveget megfelel mret darabokra trdeljk
		tok = new StringTokenizer(s, "|");
		while(tok.hasMoreTokens()) {
			v.addElement(tok.nextToken());
		}

		// A darabokat egy vektorba tesszk, ezzel elksztjk a kdol metdusnak
		temp = new BigInteger[v.size()];
		for(int j = 0; j < temp.length; j++) {
			temp[j] = new BigInteger((String)(v.elementAt(j)));
		}

		return temp;
	}

	//Kdol metdus
	public void doEncryption() {

		if(keys == null) {
			statuslabel.setText("llapot: HIBA, nincsen aktv kulcspr");
			return;
		}

		// Beolvassuk a szveget s kdoljuk
		message = textarea.getText();
		// Meghvjuk az RSA osztly kdol metdust
		encrypted = RSA.encrypt(message, keys.getPublicKey(), keys.getModulo());

		if(encrypted != null) {
		
			// A szveget a kdolt szveggel helyettestjk
			textarea.setText("");

			for(int i = 0; i < encrypted.length; i++)
				textarea.append(encrypted[i].toString() + "|");

			statuslabel.setText("llapot: a szveg sikerlt lekdolni");
		} else {
			statuslabel.setText("llapot: HIBA trtnt a kdols alatt");
		}
	}

//Dekdol eljrs
	public void doDecryption() {

		// Ellenrizzk a kulcsokat	
		if(keys == null) {
			statuslabel.setText("llapot: HIBA, nincsen aktv kulcspr");
			return;
		}

		// az RSA osztly dekdol eljrsa segtsgvel visszafejtk a szveget
		decrypted = RSA.decrypt(encrypted, keys.getPrivateKey(), keys.getModulo());

		if(decrypted != null) {
		
			// Megjelentjk a dekdolt zenetet
			textarea.setText(decrypted);

			statuslabel.setText("llapot: a szveg sikeresen visszafejtve");
		} else {
			statuslabel.setText("llapot: HIBA lpett fel a dekdols alatt");
		}
	}

//Esemny kezels
	public void actionPerformed(ActionEvent e) {
		if(e.getSource() == generatebutton) {
			
			// j kulcspr ksztse
			getKeys();
		} else if(e.getSource() == encryptbutton) {
			
			// Kdols
			doEncryption();
		} else if(e.getSource() == decryptbutton) {
			
			// Dekdols s a szveg megjelentse
			encrypted = getEncryptedText();	
			doDecryption();
		} else if(e.getSource() == setpublicbutton) {
			
			// Nyilvnos kulcs belltsa
			if(keys == null) keys = new Keys();
			statuslabel.setText("llapot: nyilvnos kulcs beolvassa");

			if (keys.setPublicKey(publickeyfield.getText()))
				statuslabel.setText("llapot: nyilvnos kulcs beolvasva");
			else
				statuslabel.setText("llapot: HIBA, helytelen nyilvnos kulcs forma");
		} else if(e.getSource() == setprivatebutton) {
			
			// A titkos kulcs belltsa
			if(keys == null) keys = new Keys();
			statuslabel.setText("llapot: titkos kulcs beolvassa");

			if (keys.setPrivateKey(privatekeyfield.getText()))
				statuslabel.setText("llapot: titkos kulcs beolvasva");
			else
				statuslabel.setText("llapot: HIBA, helytelen titkos kulcs forma");
		}
	}

} // RSAClient osztly vge
