/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl.x11;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLCapabilitiesChooser;
import net.java.games.jogl.GLException;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.JAWT_DrawingSurface;
import net.java.games.jogl.impl.JAWT_DrawingSurfaceInfo;
import net.java.games.jogl.impl.x11.GLX;
import net.java.games.jogl.impl.x11.JAWT_X11DrawingSurfaceInfo;
import net.java.games.jogl.impl.x11.X11GLContext;
import net.java.games.jogl.impl.x11.X11GLImpl;
import net.java.games.jogl.impl.x11.X11PbufferGLContext;

public class X11OnscreenGLContext
extends X11GLContext {
    private JAWT_DrawingSurface ds;
    private JAWT_DrawingSurfaceInfo dsi;
    private JAWT_X11DrawingSurfaceInfo x11dsi;
    List pbuffersToInstantiate = new ArrayList();

    public X11OnscreenGLContext(Component component, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) {
        super(component, gLCapabilities, gLCapabilitiesChooser, gLContext);
    }

    protected GL createGL() {
        return new X11GLImpl(this);
    }

    protected boolean isOffscreen() {
        return false;
    }

    public int getOffscreenContextBufferedImageType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    public boolean canCreatePbufferContext() {
        return true;
    }

    public synchronized GLContext createPbufferContext(GLCapabilities gLCapabilities, int n, int n2) {
        X11PbufferGLContext x11PbufferGLContext = new X11PbufferGLContext(gLCapabilities, n, n2);
        this.pbuffersToInstantiate.add(x11PbufferGLContext);
        return x11PbufferGLContext;
    }

    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    protected synchronized boolean makeCurrent(Runnable runnable) throws GLException {
        try {
            if (!this.lockSurface()) {
                return false;
            }
            boolean bl = super.makeCurrent(runnable);
            if (bl) {
                while (!this.pbuffersToInstantiate.isEmpty()) {
                    X11PbufferGLContext x11PbufferGLContext = (X11PbufferGLContext)this.pbuffersToInstantiate.remove(this.pbuffersToInstantiate.size() - 1);
                    x11PbufferGLContext.createPbuffer(this.display, this.context);
                }
            }
            return bl;
        }
        catch (RuntimeException runtimeException) {
            try {
                this.unlockSurface();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void free() throws GLException {
        try {
            super.free();
        }
        finally {
            this.unlockSurface();
        }
    }

    public synchronized void swapBuffers() throws GLException {
        GLX.glXSwapBuffers(this.display, (int)this.drawable);
    }

    private boolean lockSurface() throws GLException {
        if (this.drawable != 0L) {
            throw new GLException("Surface already locked");
        }
        this.ds = this.getJAWT().GetDrawingSurface(this.component);
        if (this.ds == null) {
            return false;
        }
        int n = this.ds.Lock();
        if ((n & 1) != 0) {
            throw new GLException("Unable to lock surface");
        }
        if ((n & 8) != 0 && this.context != 0L) {
            GLX.glXDestroyContext(this.display, this.context);
            this.context = 0L;
        }
        this.dsi = this.ds.GetDrawingSurfaceInfo();
        if (this.dsi == null) {
            this.ds.Unlock();
            this.getJAWT().FreeDrawingSurface(this.ds);
            this.ds = null;
            return false;
        }
        this.x11dsi = (JAWT_X11DrawingSurfaceInfo)this.dsi.platformInfo();
        this.display = this.x11dsi.display();
        this.drawable = this.x11dsi.drawable();
        this.visualID = this.x11dsi.visualID();
        if (this.display == 0L || this.drawable == 0L) {
            this.ds.FreeDrawingSurfaceInfo(this.dsi);
            this.ds.Unlock();
            this.getJAWT().FreeDrawingSurface(this.ds);
            this.ds = null;
            this.dsi = null;
            this.x11dsi = null;
            this.display = 0L;
            this.drawable = 0L;
            this.visualID = 0L;
            return false;
        }
        this.mostRecentDisplay = this.display;
        return true;
    }

    private void unlockSurface() {
        if (this.drawable == 0L) {
            throw new GLException("Surface already unlocked");
        }
        this.ds.FreeDrawingSurfaceInfo(this.dsi);
        this.ds.Unlock();
        this.getJAWT().FreeDrawingSurface(this.ds);
        this.ds = null;
        this.dsi = null;
        this.x11dsi = null;
        this.display = 0L;
        this.drawable = 0L;
        this.visualID = 0L;
    }

    protected void create() {
        this.chooseVisualAndCreateContext(true);
    }
}

