/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLUquadric;

class GLUquadricImpl
implements GLUquadric {
    private int drawStyle = 100012;
    private int orientation = 100020;
    private boolean textureFlag = false;
    private int normals = 100000;
    private static final float PI = (float)Math.PI;
    private static final int CACHE_SIZE = 240;

    GLUquadricImpl() {
    }

    void setDrawStyle(int n) {
        this.drawStyle = n;
    }

    void setNormals(int n) {
        this.normals = n;
    }

    void setOrientation(int n) {
        this.orientation = n;
    }

    void setTextureFlag(boolean bl) {
        this.textureFlag = bl;
    }

    int getDrawStyle() {
        return this.drawStyle;
    }

    int getNormals() {
        return this.normals;
    }

    int getOrientation() {
        return this.orientation;
    }

    boolean getTextureFlag() {
        return this.textureFlag;
    }

    void drawCylinder(GL gL, float f, float f2, float f3, int n, int n2) {
        float f4 = this.orientation == 100021 ? -1.0f : 1.0f;
        float f5 = (float)Math.PI * 2 / (float)n;
        float f6 = (f2 - f) / (float)n2;
        float f7 = f3 / (float)n2;
        float f8 = (f - f2) / f3;
        if (this.drawStyle == 100010) {
            gL.glBegin(0);
            for (int i = 0; i < n; ++i) {
                float f9 = this.cos((float)i * f5);
                float f10 = this.sin((float)i * f5);
                this.normal3f(gL, f9 * f4, f10 * f4, f8 * f4);
                float f11 = 0.0f;
                float f12 = f;
                for (int j = 0; j <= n2; ++j) {
                    gL.glVertex3f(f9 * f12, f10 * f12, f11);
                    f11 += f7;
                    f12 += f6;
                }
            }
            gL.glEnd();
        } else if (this.drawStyle == 100011 || this.drawStyle == 100013) {
            float f13;
            float f14;
            int n3;
            if (this.drawStyle == 100011) {
                float f15 = 0.0f;
                float f16 = f;
                for (int i = 0; i <= n2; ++i) {
                    gL.glBegin(2);
                    for (n3 = 0; n3 < n; ++n3) {
                        f14 = this.cos((float)n3 * f5);
                        f13 = this.sin((float)n3 * f5);
                        this.normal3f(gL, f14 * f4, f13 * f4, f8 * f4);
                        gL.glVertex3f(f14 * f16, f13 * f16, f15);
                    }
                    gL.glEnd();
                    f15 += f7;
                    f16 += f6;
                }
            } else if ((double)f != 0.0) {
                gL.glBegin(2);
                for (n3 = 0; n3 < n; ++n3) {
                    f14 = this.cos((float)n3 * f5);
                    f13 = this.sin((float)n3 * f5);
                    this.normal3f(gL, f14 * f4, f13 * f4, f8 * f4);
                    gL.glVertex3f(f14 * f, f13 * f, 0.0f);
                }
                gL.glEnd();
                gL.glBegin(2);
                for (n3 = 0; n3 < n; ++n3) {
                    f14 = this.cos((float)n3 * f5);
                    f13 = this.sin((float)n3 * f5);
                    this.normal3f(gL, f14 * f4, f13 * f4, f8 * f4);
                    gL.glVertex3f(f14 * f2, f13 * f2, f3);
                }
                gL.glEnd();
            }
            gL.glBegin(1);
            for (n3 = 0; n3 < n; ++n3) {
                f14 = this.cos((float)n3 * f5);
                f13 = this.sin((float)n3 * f5);
                this.normal3f(gL, f14 * f4, f13 * f4, f8 * f4);
                gL.glVertex3f(f14 * f, f13 * f, 0.0f);
                gL.glVertex3f(f14 * f2, f13 * f2, f3);
            }
            gL.glEnd();
        } else if (this.drawStyle == 100012) {
            float f17 = 1.0f / (float)n;
            float f18 = 1.0f / (float)n2;
            float f19 = 0.0f;
            float f20 = 0.0f;
            float f21 = f;
            for (int i = 0; i < n2; ++i) {
                float f22 = 0.0f;
                gL.glBegin(8);
                for (int j = 0; j <= n; ++j) {
                    float f23;
                    float f24;
                    if (j == n) {
                        f24 = this.sin(0.0f);
                        f23 = this.cos(0.0f);
                    } else {
                        f24 = this.sin((float)j * f5);
                        f23 = this.cos((float)j * f5);
                    }
                    if (f4 == 1.0f) {
                        this.normal3f(gL, f24 * f4, f23 * f4, f8 * f4);
                        this.TXTR_COORD(gL, f22, f19);
                        gL.glVertex3f(f24 * f21, f23 * f21, f20);
                        this.normal3f(gL, f24 * f4, f23 * f4, f8 * f4);
                        this.TXTR_COORD(gL, f22, f19 + f18);
                        gL.glVertex3f(f24 * (f21 + f6), f23 * (f21 + f6), f20 + f7);
                    } else {
                        this.normal3f(gL, f24 * f4, f23 * f4, f8 * f4);
                        this.TXTR_COORD(gL, f22, f19);
                        gL.glVertex3f(f24 * f21, f23 * f21, f20);
                        this.normal3f(gL, f24 * f4, f23 * f4, f8 * f4);
                        this.TXTR_COORD(gL, f22, f19 + f18);
                        gL.glVertex3f(f24 * (f21 + f6), f23 * (f21 + f6), f20 + f7);
                    }
                    f22 += f17;
                }
                gL.glEnd();
                f21 += f6;
                f19 += f18;
                f20 += f7;
            }
        }
    }

    public void drawDisk(GL gL, float f, float f2, int n, int n2) {
        if (this.normals != 100002) {
            if (this.orientation == 100020) {
                gL.glNormal3f(0.0f, 0.0f, 1.0f);
            } else {
                gL.glNormal3f(0.0f, 0.0f, -1.0f);
            }
        }
        float f3 = (float)Math.PI * 2 / (float)n;
        float f4 = (f2 - f) / (float)n2;
        switch (this.drawStyle) {
            case 100012: {
                float f5 = 2.0f * f2;
                float f6 = f;
                for (int i = 0; i < n2; ++i) {
                    float f7;
                    float f8;
                    float f9;
                    int n3;
                    float f10 = f6 + f4;
                    if (this.orientation == 100020) {
                        gL.glBegin(8);
                        for (n3 = 0; n3 <= n; ++n3) {
                            f9 = n3 == n ? 0.0f : (float)n3 * f3;
                            f8 = this.sin(f9);
                            f7 = this.cos(f9);
                            this.TXTR_COORD(gL, 0.5f + f8 * f10 / f5, 0.5f + f7 * f10 / f5);
                            gL.glVertex2f(f10 * f8, f10 * f7);
                            this.TXTR_COORD(gL, 0.5f + f8 * f6 / f5, 0.5f + f7 * f6 / f5);
                            gL.glVertex2f(f6 * f8, f6 * f7);
                        }
                        gL.glEnd();
                    } else {
                        gL.glBegin(8);
                        for (n3 = n; n3 >= 0; --n3) {
                            f9 = n3 == n ? 0.0f : (float)n3 * f3;
                            f8 = this.sin(f9);
                            f7 = this.cos(f9);
                            this.TXTR_COORD(gL, 0.5f - f8 * f10 / f5, 0.5f + f7 * f10 / f5);
                            gL.glVertex2f(f10 * f8, f10 * f7);
                            this.TXTR_COORD(gL, 0.5f - f8 * f6 / f5, 0.5f + f7 * f6 / f5);
                            gL.glVertex2f(f6 * f8, f6 * f7);
                        }
                        gL.glEnd();
                    }
                    f6 = f10;
                }
                break;
            }
            case 100011: {
                float f11;
                int n4;
                float f12;
                int n5;
                for (n5 = 0; n5 <= n2; ++n5) {
                    f12 = f + (float)n5 * f4;
                    gL.glBegin(2);
                    for (n4 = 0; n4 < n; ++n4) {
                        f11 = (float)n4 * f3;
                        gL.glVertex2f(f12 * this.sin(f11), f12 * this.cos(f11));
                    }
                    gL.glEnd();
                }
                for (n4 = 0; n4 < n; ++n4) {
                    f12 = (float)n4 * f3;
                    f11 = this.sin(f12);
                    float f13 = this.cos(f12);
                    gL.glBegin(3);
                    for (n5 = 0; n5 <= n2; ++n5) {
                        float f14 = f + (float)n5 * f4;
                        gL.glVertex2f(f14 * f11, f14 * f13);
                    }
                    gL.glEnd();
                }
                break;
            }
            case 100010: {
                gL.glBegin(0);
                for (int i = 0; i < n; ++i) {
                    float f15 = (float)i * f3;
                    float f16 = this.sin(f15);
                    float f17 = this.cos(f15);
                    for (int j = 0; j <= n2; ++j) {
                        float f18 = f * (float)j * f4;
                        gL.glVertex2f(f18 * f16, f18 * f17);
                    }
                }
                gL.glEnd();
                break;
            }
            case 100013: {
                float f19;
                float f20;
                float f21;
                if ((double)f != 0.0) {
                    gL.glBegin(2);
                    f21 = 0.0f;
                    while ((double)f21 < 6.2831854820251465) {
                        f20 = f * this.sin(f21);
                        f19 = f * this.cos(f21);
                        gL.glVertex2f(f20, f19);
                        f21 += f3;
                    }
                    gL.glEnd();
                }
                gL.glBegin(2);
                for (f21 = 0.0f; f21 < (float)Math.PI * 2; f21 += f3) {
                    f20 = f2 * this.sin(f21);
                    f19 = f2 * this.cos(f21);
                    gL.glVertex2f(f20, f19);
                }
                gL.glEnd();
                break;
            }
            default: {
                return;
            }
        }
    }

    public void drawPartialDisk(GL gL, float f, float f2, int n, int n2, float f3, float f4) {
        int n3;
        float[] fArray = new float[240];
        float[] fArray2 = new float[240];
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (n >= 240) {
            n = 239;
        }
        if (n < 2 || n2 < 1 || f2 <= 0.0f || f < 0.0f || f > f2) {
            System.err.println("PartialDisk: GLU_INVALID_VALUE");
            return;
        }
        if (f4 < -360.0f) {
            f4 = 360.0f;
        }
        if (f4 > 360.0f) {
            f4 = 360.0f;
        }
        if (f4 < 0.0f) {
            f3 += f4;
            f4 = -f4;
        }
        int n4 = f4 == 360.0f ? n : n + 1;
        float f7 = f2 - f;
        float f8 = f3 / 180.0f * (float)Math.PI;
        for (n3 = 0; n3 <= n; ++n3) {
            float f9 = f8 + (float)Math.PI * f4 / 180.0f * (float)n3 / (float)n;
            fArray[n3] = this.sin(f9);
            fArray2[n3] = this.cos(f9);
        }
        if (f4 == 360.0f) {
            fArray[n] = fArray[0];
            fArray2[n] = fArray2[0];
        }
        switch (this.normals) {
            case 100000: 
            case 100001: {
                if (this.orientation == 100020) {
                    gL.glNormal3f(0.0f, 0.0f, 1.0f);
                    break;
                }
                gL.glNormal3f(0.0f, 0.0f, -1.0f);
                break;
            }
        }
        block3 : switch (this.drawStyle) {
            case 100012: {
                float f10;
                int n5;
                if (f == 0.0f) {
                    n5 = n2 - 1;
                    gL.glBegin(6);
                    if (this.textureFlag) {
                        gL.glTexCoord2f(0.5f, 0.5f);
                    }
                    gL.glVertex3f(0.0f, 0.0f, 0.0f);
                    f10 = f2 - f7 * ((float)(n2 - 1) / (float)n2);
                    if (this.textureFlag) {
                        f5 = f10 / f2 / 2.0f;
                    }
                    if (this.orientation == 100020) {
                        for (n3 = n; n3 >= 0; --n3) {
                            if (this.textureFlag) {
                                gL.glTexCoord2f(f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                            }
                            gL.glVertex3f(f10 * fArray[n3], f10 * fArray2[n3], 0.0f);
                        }
                    } else {
                        for (n3 = 0; n3 <= n; ++n3) {
                            if (this.textureFlag) {
                                gL.glTexCoord2f(f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                            }
                            gL.glVertex3f(f10 * fArray[n3], f10 * fArray2[n3], 0.0f);
                        }
                    }
                    gL.glEnd();
                } else {
                    n5 = n2;
                }
                for (int i = 0; i < n5; ++i) {
                    f10 = f2 - f7 * ((float)i / (float)n2);
                    float f11 = f2 - f7 * ((float)(i + 1) / (float)n2);
                    if (this.textureFlag) {
                        f5 = f10 / f2 / 2.0f;
                        f6 = f11 / f2 / 2.0f;
                    }
                    gL.glBegin(8);
                    for (n3 = 0; n3 <= n; ++n3) {
                        if (this.orientation == 100020) {
                            if (this.textureFlag) {
                                gL.glTexCoord2f(f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                            }
                            gL.glVertex3f(f10 * fArray[n3], f10 * fArray2[n3], 0.0f);
                            if (this.textureFlag) {
                                gL.glTexCoord2f(f6 * fArray[n3] + 0.5f, f6 * fArray2[n3] + 0.5f);
                            }
                            gL.glVertex3f(f11 * fArray[n3], f11 * fArray2[n3], 0.0f);
                            continue;
                        }
                        if (this.textureFlag) {
                            gL.glTexCoord2f(f6 * fArray[n3] + 0.5f, f6 * fArray2[n3] + 0.5f);
                        }
                        gL.glVertex3f(f11 * fArray[n3], f11 * fArray2[n3], 0.0f);
                        if (this.textureFlag) {
                            gL.glTexCoord2f(f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                        }
                        gL.glVertex3f(f10 * fArray[n3], f10 * fArray2[n3], 0.0f);
                    }
                    gL.glEnd();
                }
                break;
            }
            case 100010: {
                gL.glBegin(0);
                for (n3 = 0; n3 < n4; ++n3) {
                    float f12 = fArray[n3];
                    float f13 = fArray2[n3];
                    for (int i = 0; i <= n2; ++i) {
                        float f14 = f2 - f7 * ((float)i / (float)n2);
                        if (this.textureFlag) {
                            f5 = f14 / f2 / 2.0f;
                            gL.glTexCoord2f(f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                        }
                        gL.glVertex3f(f14 * f12, f14 * f13, 0.0f);
                    }
                }
                gL.glEnd();
                break;
            }
            case 100011: {
                float f15;
                int n6;
                if (f == f2) {
                    gL.glBegin(3);
                    for (n3 = 0; n3 <= n; ++n3) {
                        if (this.textureFlag) {
                            gL.glTexCoord2f(fArray[n3] / 2.0f + 0.5f, fArray2[n3] / 2.0f + 0.5f);
                        }
                        gL.glVertex3f(f * fArray[n3], f * fArray2[n3], 0.0f);
                    }
                    gL.glEnd();
                    break;
                }
                for (n6 = 0; n6 <= n2; ++n6) {
                    f15 = f2 - f7 * ((float)n6 / (float)n2);
                    if (this.textureFlag) {
                        f5 = f15 / f2 / 2.0f;
                    }
                    gL.glBegin(3);
                    for (n3 = 0; n3 <= n; ++n3) {
                        if (this.textureFlag) {
                            gL.glTexCoord2f(f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                        }
                        gL.glVertex3f(f15 * fArray[n3], f15 * fArray2[n3], 0.0f);
                    }
                    gL.glEnd();
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    float f16 = fArray[n3];
                    float f17 = fArray2[n3];
                    gL.glBegin(3);
                    for (n6 = 0; n6 <= n2; ++n6) {
                        f15 = f2 - f7 * ((float)n6 / (float)n2);
                        if (this.textureFlag) {
                            f5 = f15 / f2 / 2.0f;
                        }
                        if (this.textureFlag) {
                            gL.glTexCoord2f(f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                        }
                        gL.glVertex3f(f15 * f16, f15 * f17, 0.0f);
                    }
                    gL.glEnd();
                }
                break;
            }
            case 100013: {
                float f18;
                int n7;
                if (f4 < 360.0f) {
                    for (n3 = 0; n3 <= n; n3 += n) {
                        float f19 = fArray[n3];
                        float f20 = fArray2[n3];
                        gL.glBegin(3);
                        for (n7 = 0; n7 <= n2; ++n7) {
                            f18 = f2 - f7 * ((float)n7 / (float)n2);
                            if (this.textureFlag) {
                                f5 = f18 / f2 / 2.0f;
                                gL.glTexCoord2f(f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                            }
                            gL.glVertex3f(f18 * f19, f18 * f20, 0.0f);
                        }
                        gL.glEnd();
                    }
                }
                for (n7 = 0; n7 <= n2; n7 += n2) {
                    f18 = f2 - f7 * ((float)n7 / (float)n2);
                    if (this.textureFlag) {
                        f5 = f18 / f2 / 2.0f;
                    }
                    gL.glBegin(3);
                    for (n3 = 0; n3 <= n; ++n3) {
                        if (this.textureFlag) {
                            gL.glTexCoord2f(f5 * fArray[n3] + 0.5f, f5 * fArray2[n3] + 0.5f);
                        }
                        gL.glVertex3f(f18 * fArray[n3], f18 * fArray2[n3], 0.0f);
                    }
                    gL.glEnd();
                    if (f == f2) break block3;
                }
                break;
            }
        }
    }

    public void drawSphere(GL gL, float f, int n, int n2) {
        boolean bl = this.normals != 100002;
        float f2 = this.orientation == 100021 ? -1.0f : 1.0f;
        float f3 = (float)Math.PI / (float)n2;
        float f4 = (float)Math.PI * 2 / (float)n;
        if (this.drawStyle == 100012) {
            float f5;
            float f6;
            int n3;
            int n4;
            float f7;
            float f8;
            float f9;
            float f10;
            int n5;
            if (!this.textureFlag) {
                gL.glBegin(6);
                gL.glNormal3f(0.0f, 0.0f, 1.0f);
                gL.glVertex3f(0.0f, 0.0f, f2 * f);
                for (n5 = 0; n5 <= n; ++n5) {
                    f10 = n5 == n ? 0.0f : (float)n5 * f4;
                    f9 = -this.sin(f10) * this.sin(f3);
                    f8 = this.cos(f10) * this.sin(f3);
                    f7 = f2 * this.cos(f3);
                    if (bl) {
                        gL.glNormal3f(f9 * f2, f8 * f2, f7 * f2);
                    }
                    gL.glVertex3f(f9 * f, f8 * f, f7 * f);
                }
                gL.glEnd();
            }
            float f11 = 1.0f / (float)n;
            float f12 = 1.0f / (float)n2;
            float f13 = 1.0f;
            if (this.textureFlag) {
                n4 = 0;
                n3 = n2;
            } else {
                n4 = 1;
                n3 = n2 - 1;
            }
            for (int i = n4; i < n3; ++i) {
                f6 = (float)i * f3;
                gL.glBegin(8);
                f5 = 0.0f;
                for (n5 = 0; n5 <= n; ++n5) {
                    f10 = n5 == n ? 0.0f : (float)n5 * f4;
                    f9 = -this.sin(f10) * this.sin(f6);
                    f8 = this.cos(f10) * this.sin(f6);
                    f7 = f2 * this.cos(f6);
                    if (bl) {
                        gL.glNormal3f(f9 * f2, f8 * f2, f7 * f2);
                    }
                    this.TXTR_COORD(gL, f5, f13);
                    gL.glVertex3f(f9 * f, f8 * f, f7 * f);
                    f9 = -this.sin(f10) * this.sin(f6 + f3);
                    f8 = this.cos(f10) * this.sin(f6 + f3);
                    f7 = f2 * this.cos(f6 + f3);
                    if (bl) {
                        gL.glNormal3f(f9 * f2, f8 * f2, f7 * f2);
                    }
                    this.TXTR_COORD(gL, f5, f13 - f12);
                    f5 += f11;
                    gL.glVertex3f(f9 * f, f8 * f, f7 * f);
                }
                gL.glEnd();
                f13 -= f12;
            }
            if (!this.textureFlag) {
                gL.glBegin(6);
                gL.glNormal3f(0.0f, 0.0f, -1.0f);
                gL.glVertex3f(0.0f, 0.0f, -f * f2);
                f6 = (float)Math.PI - f3;
                f5 = 1.0f;
                for (n5 = n; n5 >= 0; --n5) {
                    f10 = n5 == n ? 0.0f : (float)n5 * f4;
                    f9 = -this.sin(f10) * this.sin(f6);
                    f8 = this.cos(f10) * this.sin(f6);
                    f7 = f2 * this.cos(f6);
                    if (bl) {
                        gL.glNormal3f(f9 * f2, f8 * f2, f7 * f2);
                    }
                    f5 -= f11;
                    gL.glVertex3f(f9 * f, f8 * f, f7 * f);
                }
                gL.glEnd();
            }
        } else if (this.drawStyle == 100011 || this.drawStyle == 100013) {
            float f14;
            float f15;
            float f16;
            float f17;
            int n6;
            float f18;
            int n7;
            for (n7 = 1; n7 < n2; ++n7) {
                f18 = (float)n7 * f3;
                gL.glBegin(2);
                for (n6 = 0; n6 < n; ++n6) {
                    f17 = (float)n6 * f4;
                    f16 = this.cos(f17) * this.sin(f18);
                    f15 = this.sin(f17) * this.sin(f18);
                    f14 = this.cos(f18);
                    if (bl) {
                        gL.glNormal3f(f16 * f2, f15 * f2, f14 * f2);
                    }
                    gL.glVertex3f(f16 * f, f15 * f, f14 * f);
                }
                gL.glEnd();
            }
            for (n6 = 0; n6 < n; ++n6) {
                f17 = (float)n6 * f4;
                gL.glBegin(3);
                for (n7 = 0; n7 <= n2; ++n7) {
                    f18 = (float)n7 * f3;
                    f16 = this.cos(f17) * this.sin(f18);
                    f15 = this.sin(f17) * this.sin(f18);
                    f14 = this.cos(f18);
                    if (bl) {
                        gL.glNormal3f(f16 * f2, f15 * f2, f14 * f2);
                    }
                    gL.glVertex3f(f16 * f, f15 * f, f14 * f);
                }
                gL.glEnd();
            }
        } else if (this.drawStyle == 100010) {
            gL.glBegin(0);
            if (bl) {
                gL.glNormal3f(0.0f, 0.0f, f2);
            }
            gL.glVertex3f(0.0f, 0.0f, f);
            if (bl) {
                gL.glNormal3f(0.0f, 0.0f, -f2);
            }
            gL.glVertex3f(0.0f, 0.0f, -f);
            for (int i = 1; i < n2 - 1; ++i) {
                float f19 = (float)i * f3;
                for (int j = 0; j < n; ++j) {
                    float f20 = (float)j * f4;
                    float f21 = this.cos(f20) * this.sin(f19);
                    float f22 = this.sin(f20) * this.sin(f19);
                    float f23 = this.cos(f19);
                    if (bl) {
                        gL.glNormal3f(f21 * f2, f22 * f2, f23 * f2);
                    }
                    gL.glVertex3f(f21 * f, f22 * f, f23 * f);
                }
            }
            gL.glEnd();
        }
    }

    private void normal3f(GL gL, float f, float f2, float f3) {
        float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
        if (f4 > 1.0E-5f) {
            f /= f4;
            f2 /= f4;
            f3 /= f4;
        }
        gL.glNormal3f(f, f2, f3);
    }

    private void TXTR_COORD(GL gL, float f, float f2) {
        if (this.textureFlag) {
            gL.glTexCoord2f(f, f2);
        }
    }

    private float sin(float f) {
        return (float)Math.sin(f);
    }

    private float cos(float f) {
        return (float)Math.cos(f);
    }
}

